﻿package util
{
	import flash.net.SharedObject;
	
	
	public class SharedObjectUtil
	{
		
		//--------------------------------------------------------------------------
		//
		//  metohd
		//
		//--------------------------------------------------------------------------
		
		
		/**
		 * 値を取得
		 * 
		 * @param	element  - 要素名
		 * @param	path - パス
		 * @return	値
		 */
		public static function load(element:String, path:String = null):Object
		{
			var data:SharedObject = SharedObject.getLocal(element, path);
			return (data == null) ? null : data.data[element];
		}
		
		/**
		 * 値を設定する
		 * 
		 * @param	element - 要素名
		 * @param	value - 値
		 * @param	path - パス
		 * @return	書き込みに成功したか
		 */
		public static function save(element:String, value:Object, path:String = null):Boolean
		{
			var data:SharedObject = SharedObject.getLocal(element, path);
			data.data[element] = value;
			data.flush();
			
			return (data) ? true : false;
		}
		
		/**
		 * 値を削除する
		 * 
		 * @return	削除できたか
		 */
		public static function clear(element:String, path:String = null):Boolean
		{
			var data:SharedObject = SharedObject.getLocal(element, path);
			data.clear();
			
			return (data) ? true : false;
		}	
	}	
}
